﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using Excel = Microsoft.Office.Interop.Excel;

namespace Project_management_system
{
    public partial class Project_management_Records : Form
    {
        SqlDataReader rdr = null;
        SqlConnection con = null;
        SqlCommand cmd = null;
        ConnectionString cs = new ConnectionString();
        public Project_management_Records()
        {
            InitializeComponent();
        }

        public void GetData()  
        {
            try
            {
               
                  
                con = new SqlConnection(cs.ConDB);
                con.Open();
                String sql = "SELECT ProjectInfo.ID,ProjectInfo.EmployeeID_PM,ProjectInfo.CategoryID,ProjectDetails.StageID, ProjectInfo.ProjectName,Category.CategoryName,Stages.StageName,Employee.Name,ProjectDetails.Employee_teamleaders, ProjectDetails.Employee_members,ProjectDetails.StartingDate, ProjectDetails.CompletionDate,ProjectDetails.Description FROM Employee INNER JOIN ProjectInfo ON Employee.Id = ProjectInfo.EmployeeID_PM INNER JOIN  Category ON ProjectInfo.CategoryID = Category.Id INNER JOIN  ProjectDetails ON ProjectInfo.ID = ProjectDetails.ProjectID INNER JOIN Stages ON ProjectDetails.StageID = Stages.Id order by projectName";
                cmd = new SqlCommand(sql, con);
                rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                dataGridView1.Rows.Clear();
                while (rdr.Read() == true)
                {
                    dataGridView1.Rows.Add(rdr[0], rdr[1],rdr[2],rdr[3],rdr[4],rdr[5],rdr[6],rdr[7],rdr[8],rdr[9],rdr[10],rdr[11],rdr[12]);
                }
                con.Close();
            }
            
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void project_management_Records_Load(object sender, EventArgs e)
        {
            GetData();
        }

        private void dataGridView1_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)

        {
            string strRowNumber = (e.RowIndex + 1).ToString();
            SizeF size = e.Graphics.MeasureString(strRowNumber, this.Font);
            if (dataGridView1.RowHeadersWidth < Convert.ToInt32((size.Width + 20)))
            {
                dataGridView1.RowHeadersWidth = Convert.ToInt32((size.Width + 20));
            }
            Brush b = SystemBrushes.ControlText;
            e.Graphics.DrawString(strRowNumber, this.Font, b, e.RowBounds.Location.X + 15, e.RowBounds.Location.Y + ((e.RowBounds.Height - size.Height) / 2));
     
        }

        private void dataGridView1_RowHeaderMouseClick(object sender, DataGridViewCellMouseEventArgs e)
        {
            try
            {
                this.Hide();
                frmProjectManagement frm = new frmProjectManagement();
                frm.Show();
                DataGridViewRow dr = dataGridView1.SelectedRows[0];
                frm.txtProjectID.Text  = dr.Cells[0].Value.ToString();
                frm.txtProjectManager.Text = dr.Cells[1].Value.ToString();
                frm.txtCategoryID.Text = dr.Cells[2].Value.ToString();

                frm.txtStageID.Text = dr.Cells[3].Value.ToString();
                frm.txtProjectName.Text= dr.Cells[4].Value.ToString();
        
                frm.cmbCategory.Text = dr.Cells[5].Value.ToString();
                frm.cmbStage.Text = dr.Cells[6].Value.ToString();
               frm.cmbProjectManager.Text = dr.Cells[7].Value.ToString();
               frm.txtTeamLeaders.Text = dr.Cells[8].Value.ToString();
              frm.txtMembers.Text = dr.Cells[9].Value.ToString();
              frm.dtpStartingDate.Text = dr.Cells[10].Value.ToString();
              frm.dtpCompletionDate.Text= dr.Cells[11].Value.ToString();
                     frm.txtDescription.Text = dr.Cells[12].Value.ToString();
                     frm.lblUser.Text = lblUser.Text;
                     frm.Save.Enabled = false;
                         frm.btnUpdate.Enabled = true; 
       
                     frm.Delete.Enabled = true;
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void EmployeeName_TextChanged(object sender, EventArgs e)
        {
            
            try
            {


                con = new SqlConnection(cs.ConDB);
                con.Open();
                String sql = "SELECT ProjectInfo.ID,ProjectInfo.EmployeeID_PM,ProjectInfo.CategoryID,ProjectDetails.StageID, ProjectInfo.ProjectName,Category.CategoryName,Stages.StageName,Employee.Name,ProjectDetails.Employee_teamleaders, ProjectDetails.Employee_members,ProjectDetails.StartingDate, ProjectDetails.CompletionDate,ProjectDetails.Description FROM Employee INNER JOIN ProjectInfo ON Employee.Id = ProjectInfo.EmployeeID_PM INNER JOIN  Category ON ProjectInfo.CategoryID = Category.Id INNER JOIN  ProjectDetails ON ProjectInfo.ID = ProjectDetails.ProjectID INNER JOIN Stages ON ProjectDetails.StageID = Stages.Id and ProjectName Like '"+txtProjectName.Text +"%' order by projectName";
                cmd = new SqlCommand(sql, con);
                rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                dataGridView1.Rows.Clear();
                while (rdr.Read() == true)
                {
                    dataGridView1.Rows.Add(rdr[0], rdr[1], rdr[2], rdr[3], rdr[4], rdr[5], rdr[6], rdr[7], rdr[8], rdr[9], rdr[10], rdr[11], rdr[12]);
                }
                con.Close();
            }

           catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void NewRecord_Click(object sender, EventArgs e)
        {

           
            txtProjectName.Text = "";
            dataGridView1.DataSource = null;
            textBox1.Text = "";
        }

        private void button1_Click(object sender, EventArgs e)
        {
           
            int rowsTotal = 0;
            int colsTotal = 0;
            int I = 0;
            int j = 0;
            int iC = 0;
            System.Windows.Forms.Cursor.Current = System.Windows.Forms.Cursors.WaitCursor;
            Excel.Application xlApp = new Excel.Application();

            try
            {
                Excel.Workbook excelBook = xlApp.Workbooks.Add();
                Excel.Worksheet excelWorksheet = (Excel.Worksheet)excelBook.Worksheets[1];
                xlApp.Visible = true;

                rowsTotal = dataGridView1.RowCount - 1;
                colsTotal = dataGridView1.Columns.Count - 1;
                var _with1 = excelWorksheet;
                _with1.Cells.Select();
                _with1.Cells.Delete();
                for (iC = 0; iC <= colsTotal; iC++)
                {
                    _with1.Cells[1, iC + 1].Value = dataGridView1.Columns[iC].HeaderText;
                }
                for (I = 0; I <= rowsTotal - 1; I++)
                {
                    for (j = 0; j <= colsTotal; j++)
                    {
                        _with1.Cells[I + 2, j + 1].value = dataGridView1.Rows[I].Cells[j].Value;
                    }
                }
                _with1.Rows["1:1"].Font.FontStyle = "Bold";
                _with1.Rows["1:1"].Font.Size = 12;

                _with1.Cells.Columns.AutoFit();
                _with1.Cells.Select();
                _with1.Cells.EntireColumn.AutoFit();
                _with1.Cells[1, 1].Select();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                //RELEASE ALLOACTED RESOURCES
                System.Windows.Forms.Cursor.Current = System.Windows.Forms.Cursors.Default;
                xlApp = null;
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            try
            {


                con = new SqlConnection(cs.ConDB);
                con.Open();
                String sql = "SELECT ProjectInfo.ID,ProjectInfo.EmployeeID_PM,ProjectInfo.CategoryID,ProjectDetails.StageID, ProjectInfo.ProjectName,Category.CategoryName,Stages.StageName,Employee.Name,ProjectDetails.Employee_teamleaders, ProjectDetails.Employee_members,ProjectDetails.StartingDate, ProjectDetails.CompletionDate,ProjectDetails.Description FROM Employee INNER JOIN ProjectInfo ON Employee.Id = ProjectInfo.EmployeeID_PM INNER JOIN  Category ON ProjectInfo.CategoryID = Category.Id INNER JOIN  ProjectDetails ON ProjectInfo.ID = ProjectDetails.ProjectID INNER JOIN Stages ON ProjectDetails.StageID = Stages.Id and StageName Like '" + textBox1.Text + "%' order by StageName";
                cmd = new SqlCommand(sql, con);
                rdr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                dataGridView1.Rows.Clear();
                while (rdr.Read() == true)
                {
                    dataGridView1.Rows.Add(rdr[0], rdr[1], rdr[2], rdr[3], rdr[4], rdr[5], rdr[6], rdr[7], rdr[8], rdr[9], rdr[10], rdr[11], rdr[12]);
                }
                con.Close();
            }

            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void Project_management_Records_FormClosing(object sender, FormClosingEventArgs e)
        {
            this.Hide();
            frmProjectManagement frm = new frmProjectManagement();
            frm.lblUser.Text = lblUser.Text;
            frm.Show();
        }

        }
    }

